<?php

namespace Database\Seeders\Themes\Home4;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'our-mission',
                    'attributes' => [
                        'style' => '3',
                        'title' => ' Complex <b> IT </b> <br> <b>Solution</b> For Grow <br> Your <b>Business</b>',
                        'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                        'primary_action_label' => 'Get 15 Days Free Trial',
                        'primary_action_url' => '/contact',
                        'primary_action_icon' => 'ti ti-arrow-narrow-right',
                        'bottom_description' => 'No Card Required. Cancel Anytime.',
                        'floating_data_count_title' => 'Professionals',
                        'floating_data_count_subtitle' => 'Love Our System',
                        'floating_data_count' => '23',
                        'floating_data_count_unit' => 'k',
                        'floating_button_label' => 'Free Update',
                        'floating_button_characters_highlight' => 'Get',
                        'floating_button_url' => '/contact',
                        'quantity' => '2',
                        'title_1' => 'Transaction <br> Completed',
                        'data_1' => '12',
                        'unit_1' => 'M+',
                        'text_color_1' => 'transparent',
                        'background_color_1' => 'transparent',
                        'title_2' => 'Happy <br> Clients',
                        'data_2' => '25',
                        'unit_2' => 'k+',
                        'text_color_2' => 'transparent',
                        'background_color_2' => 'transparent',
                        'text_color_3' => 'transparent',
                        'background_color_3' => 'transparent',
                        'text_color_4' => 'transparent',
                        'background_color_4' => 'transparent',
                        'text_color_5' => 'transparent',
                        'background_color_5' => 'transparent',
                        'text_color_6' => 'transparent',
                        'background_color_6' => 'transparent',
                        'testimonial_limit' => '5',
                        'image' => $this->filePath('general/our-mission-3.png'),
                        'background_image' => $this->filePath('backgrounds/bg-line-col.png'),
                    ],
                ],
                [
                    'name' => 'partners',
                    'attributes' => [
                        'style' => 1,
                        'background_color' => '#eef2ff',
                        'quantity' => 6,
                        ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy'])
                            ->mapWithKeys(function ($name, $index) {
                                $index++;

                                $imageName = $index > 8 ? rand(1, 8) : $index;

                                return [
                                    "name_$index" => $name,
                                    "image_$index" => $this->filePath("partners/$imageName.png"),
                                    "url_$index" => 'https://google.com',
                                    "open_in_new_tab_$index" => true,
                                ];
                            })
                            ->all(),
                    ],
                ],
                [
                    'name' => 'services',
                    'attributes' => [
                        'style' => '6',
                        'title' => 'The Leading <b>IT Solutions</b><br> <b>Company</b> For You',
                        'subtitle' => 'WHAT WE OFFERS',
                        'service_ids' => '1,2,3,4,5,6',
                        'background_color' => 'transparent',
                        'background_image' => $this->filePath('backgrounds/service.png'),
                    ],
                ],
                [
                    'name' => 'our-history',
                    'attributes' => [
                        'style' => '3',
                        'title' => 'Custom Services For <br> Your Business',
                        'subtitle' => ' What We Do',
                        'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
                        'image' => $this->filePath('general/our-history-3.png'),
                        'quantity' => '4',
                        'title_1' => 'Creative Ideas',
                        'title_2' => 'Web Development',
                        'title_3' => 'Digital Marketing',
                        'title_4' => 'App Development',
                        'primary_action_label' => 'Get Free Quote',
                        'primary_action_icon' => 'ti ti-arrow-up-right',
                        'primary_action_url' => '/contact',
                        'secondary_action_label' => 'How We Work',
                        'secondary_action_url' => '/contact',
                        'floating_action_label' => 'Video Guide',
                        'floating_action_url' => 'https://www.youtube.com/watch?v=tRxGSHL8bI0',
                        'floating_action_icon' => 'ti ti-player-play',
                    ],
                ],
                [
                    'name' => 'site-statistics',
                    'attributes' => [
                        'title' => 'See why we are <br> trusted the world over',
                        'quantity' => '4',
                        'title_1' => 'New accounts',
                        'data_1' => '496',
                        'unit_1' => 'k',
                        'title_2' => 'Finished projects',
                        'data_2' => '92',
                        'unit_2' => '+',
                        'title_3' => 'Skilled experts',
                        'data_3' => '756',
                        'unit_3' => '+',
                        'title_4' => 'Media posts',
                        'data_4' => '25',
                        'unit_4' => 'k',
                    ],
                ],
                [
                    'name' => 'teams',
                    'attributes' => [
                        'style' => '6',
                        'title' => 'Meet Our Team',
                        'subtitle' => 'OUR TEAM MEMBERS',
                        'description' => 'Meet the talented and passionate team members who drive our company forward every day. <br> Company forward every day.',
                        'team_ids' => '1,2,3,4,5,6,7',
                        'quantity' => '6',
                    ],
                ],
                [
                    'name' => 'project-tabs',
                    'attributes' => [
                        'title' => 'Explore Our Projects',
                        'subtitle' => 'WHAT WE OFFERS',
                        'description' => 'It is a long established fact that a reader will be distracted by <br> the readable content of a page when looking at its layout.',
                        'quantity' => '5',
                        'title_1' => 'All Projects',
                        'title_2' => 'SEO Services',
                        'project_ids_2' => '1,7,3,4',
                        'title_3' => 'Web Design',
                        'project_ids_3' => '4,5,6,7',
                        'title_4' => 'Social',
                        'project_ids_4' => '1,3,5,7',
                        'title_5' => 'Marketing',
                        'project_ids_5' => '2,4,6,7',
                        'primary_action_label' => 'Get Free Quote',
                        'primary_action_icon' => 'ti ti-arrow-up-right',
                        'primary_action_url' => '/contact',
                        'secondary_action_label' => 'How We Work',
                        'secondary_action_url' => '/contact',
                        'background_image' => $this->filePath('backgrounds/team.png'),
                    ],
                ],
                [
                    'name' => 'information-block',
                    'attributes' => [
                        'image' => $this->filePath('icons/icon-star.png'),
                        'title' => 'Core values',
                        'description' => 'We break down barriers so teams can focus on what matters – working together to create products their customers love.',
                        'quantity' => '8',
                        'title_1' => 'Genuine repeated <br> happy customers.',
                        'data_1' => '98',
                        'unit_1' => '%',
                        'title_2' => 'Genuine repeated <br> happy customers.',
                        'data_2' => '98',
                        'unit_2' => '%',
                        'title_3' => 'Customers First',
                        'icon_image_3' => $this->filePath('icons/check.png'),
                        'description_3' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'title_4' => 'Think Big',
                        'icon_image_4' => $this->filePath('icons/check.png'),
                        'description_4' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'title_5' => 'Make a Difference',
                        'icon_image_5' => $this->filePath('icons/check.png'),
                        'description_5' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'title_6' => 'Act With Integrity',
                        'icon_image_6' => $this->filePath('icons/check.png'),
                        'description_6' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'title_7' => 'Do the right thing',
                        'icon_image_7' => $this->filePath('icons/check.png'),
                        'description_7' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'title_8' => 'Stronger united',
                        'icon_image_8' => $this->filePath('icons/check.png'),
                        'description_8' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'description_9' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'description_10' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                        'background_color' => '#a38cff',
                    ],
                ],
                [
                    'name' => 'features',
                    'attributes' => [
                        'style' => '5',
                        'title' => 'Manage all from <br> anywhere',
                        'subtitle' => 'Download Mobile App',
                        'description' => '⚡Don\'t miss any contact. Stay connected.',
                        'checklist' => 'Beautiful awesome interface \n Online collaborative anytime \n Real-time updates',
                        'floating_card_image' => $this->filePath('general/features-5.png'),
                        'floating_card_title' => 'Contact Us',
                        'floating_card_icon_image' => $this->filePath('icons/contact.png'),
                        'floating_card_button_label' => '+01 (24) 568 900',
                        'floating_card_button_url' => 'tel:0124568900',
                        'quantity' => '3',
                        'data_count_title_1' => 'Genuine happy <br> customers',
                        'data_count_1' => '99',
                        'data_count_unit_1' => '%',
                        'data_count_title_2' => 'Happy <br> Customers',
                        'data_count_2' => '92',
                        'data_count_unit_2' => 'k',
                        'data_count_title_3' => ' Consultation <br> Completed',
                        'data_count_3' => '25',
                        'data_count_unit_3' => 'k',
                    ],
                ],
                [
                    'name' => 'features',
                    'attributes' => [
                        'style' => '6',
                        'title' => 'We Provide Best IT Services <br> For Your Need',
                        'description' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
                        'image' => $this->filePath('general/features-6.png'),
                        'floating_card_image' => $this->filePath('shapes/testimonial-star.png'),
                        'floating_card_title' => 'Loved by over 4k <br> happy clients',
                        'quantity' => '5,5',
                        'title_1' => 'Digital product engineering',
                        'description_1' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
                        'title_2' => 'Crafting SaaS development',
                        'description_2' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                        'title_3' => 'AI app development',
                        'description_3' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                        'title_4' => 'E-commerce development',
                        'description_4' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                        'title_5' => 'Web Development Services',
                        'description_5' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                    ],
                ],
                [
                    'name' => 'instruction-steps',
                    'attributes' => [
                        'style' => '2',
                        'title' => 'How It Works',
                        'subtitle' => 'working process',
                        'description' => 'Comprehensive Suite of Cutting-Edge IT Services.',
                        'quantity' => '3',
                        'title_1' => 'Choose Services',
                        'description_1' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                        'icon_image_1' => $this->filePath('icons/icon-16.png'),
                        'title_2' => 'Project Analysis',
                        'description_2' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                        'icon_image_2' => $this->filePath('icons/icon-14.png'),
                        'title_3' => 'Got Final Result',
                        'description_3' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                        'icon_image_3' => $this->filePath('icons/icon-15.png'),
                        'bottom_description' => 'Need more help? Go to our',
                        'action_label' => 'Support Center',
                        'action_url' => '/contact',
                        'background_image' => $this->filePath('backgrounds/team.png'),
                    ],
                ],
                [
                    'name' => 'features',
                    'attributes' => [
                        'style' => '7',
                        'title' => 'Looking to speak with a marketing specialist?',
                        'subtitle' => 'WHAT WE OFFERS',
                        'description' => 'Our seasoned marketing specialists are here to help! Whether you need insights on digital campaigns, social media tactics, or overall branding, our experts offer tailored advice to meet your specific needs.',
                        'image' => $this->filePath('general/features-7.png'),
                        'primary_action_label' => 'Get Free Quote',
                        'primary_action_icon' => 'ti ti-arrow-up-right',
                        'primary_action_url' => '/contact',
                        'secondary_action_label' => 'How We Work',
                        'secondary_action_url' => '/contact',
                    ],
                ],
                [
                    'name' => 'blog-posts',
                    'attributes' => [
                        'style' => '2',
                        'title' => 'Our Latest Articles',
                        'description' => 'Explore the insights and trends shaping our industry',
                        'category_ids' => '1,2,3,4',
                    ],
                ],
            ]),
        ]);
    }
}
