<div class="row">
    <div @class(['col-lg-7', 'col-lg-12' => ! $shortcode->image])>
        @foreach($features as $feature)
            <div @class(['d-flex', 'pt-3' => ! $loop->first])>
                @if(! empty($feature['icon_image']))
                    <div class="bg-primary-soft icon-flip position-relative icon-shape icon-xxl rounded-3">
                        <div class="icon">
                            <img src="{{ RvMedia::getImageUrl($feature['icon_image']) }}" alt="icon" class="icon-image">
                        </div>
                    </div>
                @elseif($feature['icon'])
                    <div class="bg-primary-soft icon-flip position-relative icon-shape icon-xxl rounded-3">
                        <div class="icon">
                            <x-core::icon :name="$feature['icon']" class="text-primary" style="stroke-width: 1; width: 48px; height: 48px;"/>
                        </div>
                    </div>
                @endif
                <div class="ps-5">
                    @if($feature['title'])
                        <h6>{{ $feature['title'] }}</h6>
                    @endif
                    <p>{!! BaseHelper::clean(nl2br($feature['description'])) !!}</p>
                </div>
            </div>
        @endforeach
    </div>
    @if($shortcode->image)
        <div class="col-lg-5 mt-lg-0 mt-5">
            {{ RvMedia::image($shortcode->image, Theme::getSiteTitle(), attributes: ['class' => 'rounded-3']) }}
        </div>
    @endif
</div>
